<?php
require_once 'config.php';

if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';

    if (empty($username) || empty($full_name) || empty($email) || empty($password) || empty($confirmPassword)) {
        $error = 'جميع الحقول مطلوبة';
    } elseif ($password !== $confirmPassword) {
        $error = 'كلمات المرور غير متطابقة';
    } else {
        try {
            $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
            if ($stmt === false) {
                throw new Exception('Prepare failed: ' . $conn->error);
            }
            $stmt->bind_param('s', $username);
            $stmt->execute();
            $stmt->store_result();
            if ($stmt->num_rows > 0) {
                $error = 'اسم المستخدم موجود بالفعل';
            } else {
                // فحص تكرار البريد الإلكتروني
                $stmt_email = $conn->prepare("SELECT id FROM users WHERE email = ?");
                if ($stmt_email === false) {
                    throw new Exception('Prepare failed: ' . $conn->error);
                }
                $stmt_email->bind_param('s', $email);
                $stmt_email->execute();
                $stmt_email->store_result();
                if ($stmt_email->num_rows > 0) {
                    $error = 'البريد الإلكتروني مستخدم بالفعل';
                } else {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

                    $stmt_insert = $conn->prepare("INSERT INTO users (username, password, full_name, email, phone, balance, role, status, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
                    if ($stmt_insert === false) {
                        throw new Exception('Prepare failed: ' . $conn->error);
                    }
                    $phone = '';
                    $balance = 0;
                    $role = 'user';
                    $status = 'active';
                    $stmt_insert->bind_param('sssssdss', $username, $hashed_password, $full_name, $email, $phone, $balance, $role, $status);
                    if ($stmt_insert->execute()) {
                        $success = 'تم إنشاء الحساب بنجاح! يمكنك الآن تسجيل الدخول';
                        header('Location: login.php');
                        exit();
                    } else {
                        $error = 'حدث خطأ أثناء إنشاء الحساب: ' . $stmt_insert->error;
                    }
                    $stmt_insert->close();
                }
                $stmt_email->close();
            }
            $stmt->close();
        } catch (mysqli_sql_exception $e) {
            $error = 'حدث خطأ أثناء إنشاء الحساب: ' . $e->getMessage();
        } catch (Exception $e) {
            $error = 'حدث خطأ أثناء إنشاء الحساب: ' . $e->getMessage();
        } finally {
            if (isset($conn) && $conn) {
                $conn->close();
            }
        }
    }
}

// Include header.php AFTER all PHP logic that might set headers.
require_once 'header.php';
?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="text-center">إنشاء حساب جديد</h3>
            </div>
            <div class="card-body">
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>

                <?php if ($success): ?>
                    <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
                <?php endif; ?>

                <form method="POST" action="register.php">
                    <div class="mb-3">
                        <label for="username" class="form-label">اسم المستخدم</label>
                        <input type="text" class="form-control" id="username" name="username" placeholder="اسم المستخدم الخاص بك" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="full_name" class="form-label">الاسم الكامل</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" placeholder="اسمك الكامل" value="<?= htmlspecialchars($_POST['full_name'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="example@example.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">كلمة المرور</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="كلمة المرور" required>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">تأكيد كلمة المرور</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="تأكيد كلمة المرور" required>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary" style="background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%); border: none;">إنشاء حساب</button>
                    </div>
                </form>
                <div class="text-center mt-3">
                    <p>لديك حساب بالفعل؟ <a href="login.php">تسجيل الدخول</a></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 